package furny.swing.admin.genotype;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Logger;

import javax.swing.JFrame;

/**
 * This is a frame that contains a {@link GenotypePanel}.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class GenotypeFrame extends JFrame {
  private static final long serialVersionUID = 4463795536610612524L;

  // the logger for this class
  private static final Logger LOGGER = Logger.getLogger(GenotypeFrame.class
      .getName());

  private final GenotypePanel genotypePanel;

  /**
   * Instantiates a new genotype frame.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public GenotypeFrame() {
    super("Genotype Editor");
    setDefaultCloseOperation(EXIT_ON_CLOSE);

    setLayout(new GridBagLayout());
    final GridBagConstraints constraints = new GridBagConstraints();
    constraints.gridx = 0;
    constraints.gridy = 0;
    constraints.fill = GridBagConstraints.BOTH;
    constraints.weightx = 1.0d;
    constraints.weighty = 1.0d;

    genotypePanel = new GenotypePanel();

    add(genotypePanel, constraints);

    setSize(800, 600);
    setLocationRelativeTo(null);

    LOGGER.info("Starting up genotype panel");
  }

}
